#include "enemies.h"


Sprite* fly;
Sprite* snail; 
Sprite* bee;
Sprite* crab;

fix32 enemy_x[4] = {FIX32(50), FIX32(30), FIX32(70), FIX32(90)};
fix32 enemy_velx[4] = {FIX32(1.5), FIX32(-0.5), FIX32(2), FIX32(-0.5)};
fix32 enemy_y[4] = {FIX32(80), FIX32(40), FIX32(120), FIX32(180)};
//  u8 hitpoints[2] = {100, 100};
//  bool alive[2] =

struct Enemy current_enemies[10] = 
{
    {1, FIX32(50), FIX32(80), FIX32(1.5), NULL, 1, &img_fly },
    {1, FIX32(30), FIX32(40), FIX32(-0.5), NULL, 1, &img_snail },
    {1, FIX32(70), FIX32(120), FIX32(2.0), NULL, 1, &img_bee },
    {1, FIX32(90), FIX32(180), FIX32(-0.5), NULL, 1, &img_crab },
    
    {0, FIX32(50), FIX32(80), FIX32(1.5), NULL, 1, &img_fly },
    {0, FIX32(50), FIX32(80), FIX32(1.5), NULL, 1, &img_fly },
    {0, FIX32(50), FIX32(80), FIX32(1.5), NULL, 1, &img_fly },
    {0, FIX32(50), FIX32(80), FIX32(1.5), NULL, 1, &img_fly },
    {0, FIX32(50), FIX32(80), FIX32(1.5), NULL, 1, &img_fly },
    {0, FIX32(50), FIX32(80), FIX32(1.5), NULL, 1, &img_fly }

};

void createEnemies(){
    
    //Palette assignment
    PAL_setPalette(PAL2, img_snail.palette->data, DMA);
    PAL_setPalette(PAL1, img_bee.palette->data, DMA);

    //for() statement for iterating through array
    for (u8 i = 0; i < 10; i++)
    {
        if (current_enemies[i].status != 0)
        {
            u8 pal = (i <= 1) ? PAL2 : (i <= 3) ? PAL1 : PAL0; // fallback for unused rows

            current_enemies[i].sprite = SPR_addSprite(
                current_enemies[i].graphic,
                fix32ToInt(current_enemies[i].x),
                fix32ToInt(current_enemies[i].y),
                TILE_ATTR(pal, FALSE, FALSE, FALSE)
            );
        }
    }


}

void manageEnemies(){
    for(u8 i = 0; i < 10; i++){
        if (current_enemies[i].status != 0)
        {
            current_enemies[i].x += current_enemies[i].vel_x;
            SPR_setPosition(current_enemies[i].sprite, 
                fix32ToInt(current_enemies[i].x),
                fix32ToInt(current_enemies[i].y));
        }
    }

/*  Old code: 

    // Fly
    SPR_setPosition(fly, fix32ToInt(enemy_x[0]), fix32ToInt(enemy_y[0]));
    SPR_setHFlip(fly, TRUE);    

    // Snail
    SPR_setPosition(snail, fix32ToInt(enemy_x[1]), fix32ToInt(enemy_y[1]));
    SPR_setHFlip(snail, FALSE);

    // Bee
    SPR_setPosition(bee, fix32ToInt(enemy_x[2]), fix32ToInt(enemy_y[2]));
    SPR_setHFlip(bee, TRUE);

    // Crab
    SPR_setPosition(crab, fix32ToInt(enemy_x[3]), fix32ToInt(enemy_y[3]));
    SPR_setHFlip(crab, FALSE);

    */
}